// Byteseeker Jr.

#include <stdint.h>
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <EEPROM.h>  // <-- Ajouté pour la sauvegarde
#define SAMPLE_RATE 8000

byte ledPin = 13;
byte speakerPin = 11;
int t = 0;
unsigned int lastTime = 0;
unsigned int thisTime = 0;
volatile int a, b, c;
volatile int value;

const byte buttonPin = 5;    // Up button
const byte buttonPin1 = 7;   // Down button
byte state = 0;              // Current state
const byte nMAX = 17;        // Max state

byte buttonState5 = 0;       
byte buttonState7 = 0;       
byte lastButtonState5 = 1;   
byte lastButtonState7 = 1;

volatile int aTop=99;
volatile int aBottom=0;
volatile int bTop=99;
volatile int bBottom=0;
volatile int cTop=99;
volatile int cBottom=0;

void stopPlayback()
{
    TIMSK1 &= ~_BV(OCIE1A);
    TCCR1B &= ~_BV(CS10);
    TCCR2B &= ~_BV(CS10);
    digitalWrite(speakerPin, LOW);
    digitalWrite(ledPin, HIGH);
}

ISR(TIMER1_COMPA_vect) {
    switch (state) {
        case 0: value = ((t*a)&(t*t>>b))|(t/c);  aTop=1; aBottom=24; bTop=14; bBottom=1; cTop=12; cBottom=1; break;
        case 1: value = (((t|((t>>a)))+(t&((t>>b))))|(t>>(a+1))&(t>>a)&(t*(t>>b)))/c;  aTop=13; aBottom=1; bTop=15; bBottom=1; cTop=15; cBottom=1; break;
        case 2: value = (t*(t>>(a/c)|t>>(b/c)))>>(t>>((b/c)*2)); aTop=20; aBottom=1; bTop=20; bBottom=1; cTop=20; cBottom=1; break;
        case 3: value = (t*(((t>>(a*3))|(t>>(10+a)))&(b&(t>>(a*2)))))/c; aTop=8; aBottom=2; bTop=16; bBottom=1; cTop=8; cBottom=1; break;
        case 4: value = t*(((t>>a+c)&(t>>8))&((b+73)&(t>>3)))|t*(c>>a-3); aTop=16; aBottom=1; bTop=99; bBottom=0; cTop=1; cBottom=13; break;
        case 5: value = t*(((t>>a)|(t>>(b*2)))&(63&(t>>b)))|t*(t>>a+c); aTop=20; aBottom=1; bTop=8; bBottom=0; cTop=9; cBottom=1; break;
        case 6: value = ((t>>a&t)-(t>>a)+(t>>a&t))+(t*((t>>b)&b))-(t*((t>>c)&c)); aTop=10; aBottom=0; bTop=28; bBottom=0; cTop=9; cBottom=1; break;
        case 7: value = ((t%c)*(t>>a)|(0x577338)-(t>>a))/(t>>b)^(t|(t>>a)); aTop=8; aBottom=0; bTop=32; bBottom=0; cTop=128; cBottom=16; break;
        case 8: value = (t>>a|t%c|t>>(t>>16))|b+((t>>(b+1))&(a+1))|(t*(t>>((t>>(c-(a+b)))+b/3))); aTop=12; aBottom=0; bTop=20; bBottom=0; cTop=99; cBottom=1; break;
        case 9: value = t*(t>>a&t>>(a-3))^(t*(t%b))|t>>c&t>>(a-5); aTop=15; aBottom=7; bTop=10; bBottom=1; cTop=6; cBottom=0; break;
        case 10: value = (t*a&t/c)|(t*b&t/(c*2))|t>>(c/3); aTop=1; aBottom=56; bTop=56; bBottom=112; cTop=15; cBottom=1; break;
        case 11: value = (((t>>c+2)&(t>>b-1)*t)-2)>>t*a&(t>>a-5)|(t>>b-2&t>>c-3)*t-1; aTop=14; aBottom=1; bTop=13; bBottom=1; cTop=12; cBottom=1; break;
        case 12: value = (t*1|t>>c)&t%a|t*c|t>>b-c&t*t>>c|t>>b&(t*b|t>>c/3); aTop=48; aBottom=1; bTop=19; bBottom=2; cTop=3; cBottom=19; break;
        case 13: value = ((t*a)/b)|t<<c; aTop=1; aBottom=64; bTop=32; bBottom=1; cTop=1; cBottom=8; break;
        case 14: value = t*(((t>>a)^(t>>a)-1^(t>>b+1)^(t>>b)-1))|1%t^(t/c)|1%t; aTop=14; aBottom=4; bTop=14; bBottom=4; cTop=64; cBottom=2; break;
        case 15: value = t*(((t>>10)^(t>>10)-a))^3%(c+11)^t*(((t>>b)^(t>>b)-c))|9%(c+13); aTop=3; aBottom=15; bTop=16; bBottom=1; cTop=3; cBottom=15; break;
        case 16: value = (t/a)*((t>>11&t>>8|t<<b)/c); aTop=28; aBottom=1; bTop=14; bBottom=1; cTop=24; cBottom=1; break;
        case 17: value = t*a^t/b%255*c; aTop=12; aBottom=1; bTop=22; bBottom=1; cTop=22; cBottom=1; break;
    }
    OCR2A = 0xff & value;
    ++t;
}

void startPlayback()
{
    pinMode(speakerPin, OUTPUT);
    digitalWrite(ledPin, LOW);

    ASSR &= ~(_BV(EXCLK) | _BV(AS2));
    TCCR2A |= _BV(WGM21) | _BV(WGM20);
    TCCR2B &= ~_BV(WGM22);

    TCCR2A = (TCCR2A | _BV(COM2A1)) & ~_BV(COM2A0);
    TCCR2A &= ~(_BV(COM2B1) | _BV(COM2B0));

    TCCR2B = (TCCR2B & ~(_BV(CS12) | _BV(CS11))) | _BV(CS10);
    OCR2A = 0;

    cli();
    TCCR1B = (TCCR1B & ~_BV(WGM13)) | _BV(WGM12);
    TCCR1A = TCCR1A & ~(_BV(WGM11) | _BV(WGM10));
    TCCR1B = (TCCR1B & ~(_BV(CS12) | _BV(CS11))) | _BV(CS10);
    OCR1A = F_CPU / SAMPLE_RATE;
    TIMSK1 |= _BV(OCIE1A);
    sei();
}

void blinkNTimes(int n)
{
  byte dizaines = n / 10; // Clignotements longs
  byte unites = n % 10;   // Clignotements courts

  // Clignotements longs
  for (byte i = 0; i < dizaines; i++) {
    digitalWrite(ledPin, HIGH);
    delay(500); // Long
    digitalWrite(ledPin, LOW);
    delay(400);
  }

  if (dizaines > 0 && unites > 0) {
    delay(400); // Pause entre les longues et les courtes
  }

  // Clignotements courts
  for (byte i = 0; i < unites; i++) {
    digitalWrite(ledPin, HIGH);
    delay(50); // Court
    digitalWrite(ledPin, LOW);
    delay(400);
  }
}


void setup() {
    pinMode(ledPin, OUTPUT);
    digitalWrite(ledPin, LOW);
    pinMode(buttonPin, INPUT_PULLUP);
    pinMode(buttonPin1, INPUT_PULLUP);

    startPlayback();

    state = EEPROM.read(0); // <-- Lecture EEPROM au démarrage
    if (state > nMAX) {
        state = 0; // Sécurité si EEPROM corrompue
    }

    lastTime = millis();
    thisTime = millis();
}

void loop() {
    thisTime = millis();
    if ((thisTime - lastTime) > 5) {
        lastTime = thisTime;
        a = map(analogRead(0), 0, 1023, aBottom, aTop); 
        b = map(analogRead(1), 0, 1023, bBottom, bTop);
        c = map(analogRead(2), 0, 1023, cBottom, cTop);

        buttonState5 = digitalRead(buttonPin);
        if (buttonState5 != lastButtonState5) {
            if (buttonState5 == LOW) {
                if (state != nMAX) {
                    state++;
                    EEPROM.write(0, state); // <-- Sauvegarde EEPROM
                    delay(100);
                    int stateLED = state+1;
					blinkNTimes(stateLED);
                } else if (state == nMAX) {
                    state = 0;
                    EEPROM.write(0, state); // <-- Sauvegarde EEPROM
					int stateLED = state+1;
					blinkNTimes(stateLED);
                }
            }
            lastButtonState5 = buttonState5;
        }

        buttonState7 = digitalRead(buttonPin1);
        if (buttonState7 != lastButtonState7) {
            if (buttonState7 == LOW) {
                if (state != 0) {
                    state--;
                    EEPROM.write(0, state); // <-- Sauvegarde EEPROM
                    delay(100);
                    int stateLED = state+1;
					blinkNTimes(stateLED);
                } else if (state == 0) 	{ 
                    state = nMAX;
                    EEPROM.write(0, state); // <-- Sauvegarde EEPROM
					int stateLED = nMAX+1;
					blinkNTimes(stateLED);
                }
            }
            lastButtonState7 = buttonState7;
        }
    }
}
