/*
16187647  // + ____________4_btn
16220287  // - ____________5_btn
16203967  // off
16236607  // on ____________setup 
16195807  // R __POT switch__2_on
16228447  // G ________________on
16212127  // B ________________on
16244767  // W ________________on
16191727  _____________________on
16224367  _____________________on
16208047  _____________________on
16240687 // flash__POT switch off
16199887  _____________________on
16232527  _____________________on
16216207  _____________________on
16248847 // strobe_POT switch off
16189687  _____________________on
16222327  _____________________on
16206007  _____________________on
16238647 // fade___POT switch off
16197847  _____________________on
16230487  _____________________on
16214167  _____________________on
16246807 // smooth_POT switch off
CodeLen 32
Type NEC 
*/

#include <IRremote.h>
IRsend irsend;

int modeValue;
int colorValue;
int analogStateM;
int analogStateC;
int dly = 40;
boolean btnState = 0;
boolean oldBtnState = 0;
long Color[18] = {16195807, 16195807, 16228447, 16212127, 16244767, 16191727, 16224367, 16208047,
 16199887,16232527, 16216207, 16189687,16222327,16206007, 16197847, 16230487, 16214167, 16214167};
long Mode[6] = {16240687, 16240687, 16248847, 16238647, 16246807, 16246807 };

void setup()
{ 
pinMode(2,INPUT_PULLUP);     //modes switch
// IR led /PIN 3 nano due /PIN 9 mega
pinMode(4,INPUT_PULLUP);    //plus btn
pinMode(5,INPUT_PULLUP);    //moins btn
irsend.sendNEC(16236607, 32); // IR on
delay(100);
}

void loop()
{
   btnState = digitalRead(2);
   colorValue = map (analogRead(A0), 0, 1023, 0, 17);
   modeValue = map (analogRead(A0), 0, 1023, 0, 5);

   if (digitalRead(4) == LOW) // plus
     {
     irsend.sendNEC(16187647, 32);
     delay(dly);
     }
   if (digitalRead(5) == LOW) // moins
     {
     irsend.sendNEC(16220287, 32);
     delay(dly);
     }
   
   if (digitalRead(2) == LOW && digitalRead(4) == HIGH && digitalRead(5) == HIGH) // on colors
     {
     if (analogStateC !=  colorValue)
     {
     irsend.sendNEC(Color[colorValue], 32);
     delay(dly);
     }
   if (btnState !=  oldBtnState)
     {
     irsend.sendNEC(Color[colorValue], 32);
     delay(dly);
     }
   }
  if (digitalRead(2) == HIGH && digitalRead(4) == HIGH && digitalRead(5) == HIGH) //off modes
  {
    if (analogStateM != modeValue)
    {
    irsend.sendNEC(Mode[modeValue], 32);
    delay(dly);
    }
  if (btnState !=  oldBtnState)
     {
     irsend.sendNEC(Mode[modeValue], 32);
     delay(dly);
     }
  }
  analogStateC = colorValue;
  analogStateM = modeValue;
  oldBtnState = btnState;
}
