// Made By https://retroetgeek.com

#include <IRremote.h>
#define RECV_PIN 11
#define BOUTON_PIN 12

bool boolBouton = 0 ;

int codeType;
int codeLen;
// pour recevoir sur l'ir PIN 11
IRrecv irrecv(RECV_PIN);
decode_results results;

// pour envoyer sur l'ir //PIN 3 due //PIN 9 mega
IRsend irsend;



void setup()
{
  Serial.begin(115200); //57600
  irrecv.enableIRIn(); // Start the receiver
  pinMode(BOUTON_PIN,INPUT);
}

void loop()
{

  receiveCode();
  
  if(digitalRead(BOUTON_PIN)== HIGH && boolBouton == 0){
    Serial.println("------------");
    // Code decimal,Type,Bits
    //for (int i = 0; i < 3; i++) {
    sendCode (16203967,NEC,32);  // on irm
    delay(40);
    boolBouton = 1 ;
  }
  else if (digitalRead(BOUTON_PIN)== LOW){
    boolBouton = 0 ;
  }

}


void receiveCode(){

  // catch IR
  if (irrecv.decode(&results))
    {
      //recupere le type de codage, la logueur
      int codeType = results.decode_type;
      int codeLen = results.bits;
    Serial.println("-------------------");
    Serial.print("ValueHex ");   
    Serial.println(String(results.value, HEX));
    Serial.print("ValueDec ");  
    Serial.println(results.value);
    Serial.print("CodeLen ");  
    Serial.println(codeLen);
     irrecv.resume(); // Receive the next value
     
    // De quel type est le signal IR ?
   if (codeType == UNKNOWN) {
      Serial.println("Unknow Type");
    }
    else {
      if (codeType == NEC) {
         Serial.println("Type NEC ");
      } 
      else if (codeType == SONY) {
        Serial.println("Type SONY ");
      } 
      else if (codeType == PANASONIC) {
        Serial.println("Type PANASONIC ");
      }
      else if (codeType == JVC) {
        Serial.println("Type JVC ");
      } 
      else if (codeType == SAMSUNG) {
        Serial.println("Type SAMSUNG ");
      } 
      else if (codeType == RC5) {
        Serial.println("Type RC5 ");
      }
     else if (codeType == RC6) {
        Serial.println("Type RC6 ");
      }  
      else {
        Serial.print("Unexpected codeType ");
        Serial.print(codeType, DEC);
        Serial.println("");
      }
    }
  }  
}


void sendCode (long codeValue , int codeType , int codeLen){

  if (codeType == NEC) {
      irsend.sendNEC(codeValue, codeLen);
      Serial.print("Sent NEC ");
      Serial.println(codeValue, HEX);
  } 
  else if (codeType == SONY) {
    irsend.sendSony(codeValue, codeLen);
    Serial.print("Sent Sony ");
    Serial.println(codeValue, HEX);
  } 
  else if (codeType == PANASONIC) {
    irsend.sendPanasonic(codeValue, codeLen);
    Serial.print("Sent Panasonic ");
    Serial.println(codeValue, HEX);
  }
  else if (codeType == JVC) {
    irsend.sendJVC(codeValue, codeLen, false);
    Serial.print("Sent JVC ");
    Serial.println(codeValue, HEX);
  }
  else if (codeType == SAMSUNG) {
    irsend.sendSAMSUNG(codeValue, codeLen);
    Serial.print("Sent SANSUNG ");
    Serial.println(codeValue, HEX);
  } 
  else if (codeType == RC5) {
    irsend.sendRC5(codeValue, codeLen);
    Serial.print("Sent RC5 ");
    Serial.print(codeValue, HEX);
    Serial.print(" ");
    Serial.print(codeValue, DEC);
    Serial.print(" ");
    Serial.println(codeLen, DEC);
  } 
  else if (codeType == RC6) {
    irsend.sendRC6(codeValue, codeLen);
    Serial.print("Sent RC6 ");
    Serial.println(codeValue, HEX);
  }
}
