#include <Adafruit_MCP4725.h>
#include <MIDI.h> 
#include <EEPROM.h>

Adafruit_MCP4725 dac; //A4, A5
uint16_t dacValue;
int REF_1V=229;


const byte sel = 2; //button channel select
const byte cled = 3; // blinking channel led
const byte mode = 4; // mode switch
const byte inG = 5; // gate in pin
const byte ledGatePin = 6; // gate led
//8 dac 4921
const byte velo_1 = 9; //velo pin out input_1
const byte velo_2 = 10; //velo pin out input_2
//11, 13 dac 4921
const byte gatePin = 14; // gate out
byte chn;
byte lastNote;
int address = 1; // mem chn
boolean noteS = 0;

MIDI_CREATE_DEFAULT_INSTANCE();

void setup() {  

TCCR1B = TCCR1B & B11111000 | B00000001;
pinMode (sel, INPUT_PULLUP);
pinMode (cled, OUTPUT);
chn = EEPROM.read(address);
pinMode(gatePin, OUTPUT);
pinMode (ledGatePin, OUTPUT);
pinMode(velo_1, OUTPUT);
pinMode(velo_2, OUTPUT);
pinMode (inG, INPUT_PULLUP);
pinMode (mode, INPUT_PULLUP);
MIDI.setHandleNoteOn(handleNoteOn);
MIDI.setHandleNoteOff(handleNoteOff);
dac.begin(0x60);
delay (100);


if (chn == 0 || chn > 16)
{
chn = 1;
EEPROM.write(address, chn);
delay(1000);
MIDI.begin(chn);
start (chn);
}
else
{
delay(1000);
MIDI.begin(chn);
bar (chn);
}  
}

void loop() 
{
MIDI.read();
boolean schn = digitalRead(sel); // btn channnel select
boolean gateState = digitalRead(inG); // midi gate in
boolean modeState = digitalRead(mode); //mode

if (schn == LOW)
      {
      chn+=1;
      if (chn <= 16)
      {
      EEPROM.write(address, chn);
      delay(500);
      MIDI.begin(chn);
      bar (chn);
      }
      if (chn >= 17)
      {
      chn = 1;
      EEPROM.write(address, chn);
      delay(500);
      MIDI.begin(chn);
      bar(chn);
      }
      }
	  if (modeState == LOW)
	  {
		byte cv1 = map (analogRead(A6), 0, 1023, 0, 255);
		byte cv2 = map (analogRead(A1), 0, 1023, 0, 255);
		dacValue = map (analogRead(A3), 0, 1023, 0, 820);
		dac.setVoltage(dacValue, false); 
		analogWrite(velo_1, cv1);
		analogWrite(velo_2, cv2);
		  
		  if (gateState == LOW) 
		  {
      if (noteS == 0) 
      {
			digitalWrite(gatePin, HIGH);
			digitalWrite(ledGatePin, HIGH);
			noteS = 1;
		  }
		  }
		  else
		  {
          if (noteS == 1)
          {
			  digitalWrite(gatePin, LOW);
        digitalWrite(ledGatePin, LOW);
		  }
     noteS = 0;
		  }
	  }
}

void handleNoteOn(byte channel, byte note, byte velocity)
{
  boolean modeState = digitalRead(mode);
	if (note >= 24 && note <= 72 && modeState == HIGH)
  {
  lastNote = note;
  byte velo = map(velocity, 0, 127, 255, 0);
  byte olev = map(velocity, 0, 127, 0, 255);
  digitalWrite(gatePin, HIGH);
  digitalWrite(ledGatePin, HIGH);
  analogWrite(velo_1, velo);
  analogWrite(velo_2, olev);
  long outVoltmV = REF_1V * (note-24) / 12;
  dacValue = map (outVoltmV, 0, 5000, 0, 4095);
  dac.setVoltage(dacValue, false);
  }
}

void handleNoteOff(byte channel, byte note, byte velocity)
{
  if(note == lastNote)
  {
    digitalWrite(gatePin, LOW);
    digitalWrite(ledGatePin, LOW);
    analogWrite(velo_1, 255);
    analogWrite(velo_2, 0);
  }
}
void start(byte chn)
{
    for (byte i=0; i<chn; i++) 
    {
    digitalWrite(cled, HIGH);
    delay(50);
    digitalWrite(cled, LOW);
    delay(400);
    loop();
    }
}
void bar(byte chn)
{
    for (byte i=0; i<chn; i++) 
    {
    digitalWrite(cled, HIGH);
    delay(50);
    digitalWrite(cled, LOW);
    delay(400);
    }
}


