#include <MIDI.h>  
#include <EEPROM.h>
#include "SPI.h"

word outputValue = 0; // word = 16 bits
byte data = 0;
const byte vdac = 8; // pin 2 dac_4921
int a;
int REF_1V=229;

const byte sel = 2; //button channel select
const byte cled = 3; // blinking channel led
const byte mode = 4; // mode switch
const byte inG = 5; // gate in pin
const byte ledGatePin = 6; // gate led
const byte velo_1 = 9; //velo pin out input_1
const byte velo_2 = 10; //velo pin out input_2
//11, 13 dac 4921 4,3 pin dac_4921
const byte gatePin = 14; // gate out
byte lastNote;
byte chn;
boolean noteS = 0;
int address = 1; // mem chn

MIDI_CREATE_DEFAULT_INSTANCE();

void setup() 
{ 
pinMode (sel, INPUT_PULLUP);
pinMode (cled, OUTPUT);
pinMode(gatePin, OUTPUT);
pinMode (ledGatePin, OUTPUT);
chn = EEPROM.read(address);
pinMode(velo_1, OUTPUT);
pinMode(velo_2, OUTPUT);
pinMode (inG, INPUT_PULLUP);
MIDI.setHandleNoteOn(handleNoteOn);
MIDI.setHandleNoteOff(handleNoteOff);
pinMode(vdac, OUTPUT); 		//dacPin_2 verrou du DAC //9 OK 
SPI.begin(); 				//démarrage de la liaison SPI
SPI.setBitOrder(MSBFIRST);  //ard_Pin-13 --> dacPin_3
                            //ard_Pin-11 --> dacPin_4
delay (100);

if (chn == 0 || chn > 16)
{
chn = 1;
EEPROM.write(address, chn);
delay(1000);
MIDI.begin(chn);
start (chn);
}
else
{
delay(1000);
MIDI.begin(chn);
bar (chn);
}  
}

void dac(int a)
{
outputValue = a;
digitalWrite(vdac, LOW);
data = highByte(outputValue);
data = 0b00001111 & data;
data = 0b00010000 | data;
SPI.transfer(data);
data = lowByte(outputValue);
SPI.transfer(data);
digitalWrite(vdac, HIGH);
}

void loop() 
{
MIDI.read();
boolean schn = digitalRead(sel); // btn chn
boolean gateState = digitalRead(inG); // midi gate in
boolean modeState = digitalRead(mode); //mode

if (schn == LOW)
      {
      chn+=1;
      if (chn <= 16)
      {
      EEPROM.write(address, chn);
      delay(500);
      MIDI.begin(chn);
      bar (chn);
      }
      if (chn >= 17)
      {
      chn = 1;
      EEPROM.write(address, chn);
      delay(500);
      MIDI.begin(chn);
      bar(chn);
      }
      }
	  if (modeState == LOW)
	  {
	    byte cv1 = map(analogRead(A6), 0, 1023, 0, 255);
      byte cv2 = map(analogRead(A1), 0, 1023, 0, 255);
      a = map (analogRead(A3), 0, 1023, 0, 820);
      analogWrite(velo_1, cv1);
      analogWrite(velo_2, cv2);
      dac(a);
      
		if (gateState == LOW) 
		{
		if (noteS == 0) 
		{
		digitalWrite(gatePin, HIGH);
		digitalWrite(ledGatePin, HIGH);
		noteS = 1;
		}
		}
		else
		{
		if (noteS == 1)
		{
		digitalWrite(gatePin, LOW);
    digitalWrite(ledGatePin, LOW);
		}
		noteS = 0;
		}
	  }
}

void handleNoteOn(byte channel, byte note, byte velocity)
{
  boolean modeState = digitalRead(mode); //mode
  if (note >= 24 && note <= 72 && modeState == HIGH)
  {
  lastNote = note;
  byte olev = map(velocity, 0, 127, 0, 255);
  byte velo = map(velocity, 0, 127, 255, 0);
  digitalWrite(gatePin, HIGH);
  digitalWrite(ledGatePin, HIGH);
  analogWrite(velo_1, velo);
  analogWrite(velo_2, olev);
  long outVoltmV = REF_1V * (note-24) / 12;
  a = map(outVoltmV, 0, 5000, 0, 4095);
  dac(a);
  }
}

void handleNoteOff(byte channel, byte note, byte velocity)
{
  if(note == lastNote)
  {
    digitalWrite(gatePin, LOW);
    digitalWrite(ledGatePin, LOW);
    analogWrite(velo_1, 255);
    analogWrite(velo_2, 0);
  }
}
void start(byte chn)
{
    for (byte i=0; i<chn; i++) 
    {
    digitalWrite(cled, HIGH);
    delay(50);
    digitalWrite(cled, LOW);
    delay(400);
    loop();
    }
}
void bar(byte chn)
{
    for (byte i=0; i<chn; i++) 
    {
    digitalWrite(cled, HIGH);
    delay(50);
    digitalWrite(cled, LOW);
    delay(400);
    }
}


