/*  Alain COUPEL mai 2008

FIRMWARE DU PSEUDO-SEQUENCER ACSynth 

Modified by Yves USSON 01-2010


PCB #3


PORTA IN OUT					
RA0	SCK 			OUT				
RA1	DAC CS			OUT
RA2	FRQ				IN/ANALOG
RA3	DIV				IN/ANALOG
RA4	INPUT			IN/ANALOG
RA5	MCLR			IN
RA6	INTER INT/EXT	IN
RA7	SDI				OUT

TRISA = 0b01111100

PORTB IN OUT
RB0	TRIGGER/MAN		IN
RB1	QUANTIZE		IN
RB2	TRIG1			OUT
RB3	TRIG2			OUT
RB4	REC1/PLAY		IN
RB5	REC2/PLAY		IN
RB6 NC PGC			X		// USED FOR DEBUGGING
RB7	NC PGD			X		// USED FOR DEBUGGING

TRISB = 0b11110011

*/


#include<htc.h>		//Compilateur Hi-Tech PICC std



 __CONFIG(INTIO & WDTDIS & PWRTEN & MCLREN & BORDIS & LVPDIS & DEBUGDIS & CCPRB0 & UNPROTECT);
 
const unsigned char THIGH[256] = {
		  93, 95, 98,100,103,105,108,111,113,116,118,121,123,126,128,131,
		 133,136,139,141,144,146,149,151,154,156,159,161,164,166,169,172,
		 174,175,177,178,179,180,182,183,184,186,187,188,189,191,192,193,
		 194,196,197,198,200,201,202,203,205,206,207,208,210,211,212,214,
		 215,215,216,217,217,218,219,219,220,221,221,222,222,223,224,224,
		 225,226,226,227,228,228,229,229,230,231,231,232,233,233,234,235,
		 235,235,236,236,236,237,237,237,238,238,238,239,239,239,240,240,
		 240,241,241,241,242,242,242,242,243,243,243,244,244,244,245,245,
		 245,245,246,246,246,246,246,246,247,247,247,247,247,247,248,248,
		 248,248,248,248,249,249,249,249,249,249,249,250,250,250,250,250,
		 250,250,251,251,251,251,251,251,251,251,251,251,251,251,252,252,
		 252,252,252,252,252,252,252,252,252,252,252,253,253,253,253,253,
		 253,253,253,253,253,253,253,253,253,253,253,253,253,253,254,254,
		 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
		 254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,255,
		 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};

const unsigned char TLOW[256] = {
		  62,202, 85,224,107,246,129, 12,151, 34,173, 56,195, 78,217,100,
		 239,122,  5,144, 27,166, 49,188, 71,210, 93,232,115,254,137, 20,
		 159,229, 43,112,182,251, 65,134,204, 17, 87,156,226, 39,109,178,
		 248, 61,131,200, 14, 83,153,222, 36,105,175,244, 58,127,197, 10,
		  80,243,150, 57,219,126, 33,196,102,  9,172, 79,241,148, 55,218,
		 124, 31,194,101,  7,170, 77,240,146, 53,216,123, 29,192, 99,  6,
		 168,250, 75,157,238, 63,145,226, 51,133,214, 40,121,202, 28,109,
		 190, 16, 97,179,  4, 85,167,248, 73,155,236, 62,143,224, 50,131,
		 212,253, 38, 79,119,160,201,241, 26, 67,107,148,189,229, 14, 55,
		  95,136,177,218,  2, 43, 84,124,165,206,246, 31, 72,112,153,194,
		 234,255, 19, 40, 60, 80,101,121,141,162,182,202,223,243,  7, 28,
		  48, 68, 89,109,129,150,170,190,211,231,251, 16, 36, 56, 77, 97,
		 117,128,138,148,158,168,179,189,199,209,219,229,240,250,  4, 14,
		  24, 34, 45, 55, 65, 75, 85, 95,106,116,126,136,146,156,167,177,
		 187,193,198,203,208,213,218,223,228,233,238,243,248,254,  3,  8,
		  13, 18, 23, 28, 33, 38, 43, 48, 53, 58, 64, 69, 74, 79, 84, 89};
  
 
 /*  tableaux d'origine
const unsigned char THIGH[256] = {	0,10,16,21,26,31,35,40,45,49,54,58,62,66,70,74,
 							78,82,86,89,93,96,100,103,106,109,112,115,118,121,124,127,
 							130,132,135,138,140,143,145,147,150,152,154,156,158,160,162,164,
 							166,168,170,172,174,175,177,179,180,182,183,185,186,188,189,191,
 							192,193,195,196,197,199,200,201,202,203,204,205,206,207,208,209,
 							210,211,212,213,214,215,216,217,217,218,219,220,220,221,222,223,
 							223,224,225,225,226,227,227,228,228,229,229,230,230,231,231,232,
 							232,233,233,234,234,235,235,236,236,236,237,237,237,238,238,239,
 							239,239,240,240,240,241,241,241,241,242,242,242,242,243,243,243,
 							243,244,244,244,244,245,245,245,245,245,246,246,246,246,246,247,
 							247,247,247,247,247,248,248,248,248,248,248,248,248,249,249,249,
 							249,249,249,249,249,250,250,250,250,250,250,250,250,250,250,251,
 							251,251,251,251,251,251,251,251,251,251,251,251,251,252,252,252,
 							252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,253,
 							253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
 							253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,254};
 								
 const unsigned char TLOW[256] = {	0,207,11,41,44,19,224,146,42,169,15,94,148,180,189,176,
 							141,85,8,167,50,169,14,96,160,205,234,245,240,218,181,128,
 							59,231,133,20,150,9,112,201,21,84,135,175,202,218,222,216,
 							198,170,132,83,25,212,135,48,208,102,245,122,248,109,218,64,
 							157,243,66,138,203,4,56,100,138,170,195,215,229,237,239,236,
 							227,213,194,169,140,106,67,24,232,179,122,61,252,182,109,32,
 							206,121,33,197,101,2,156,50,197,85,225,107,242,118,247,118,
 							241,106,225,84,198,53,161,12,116,217,61,158,254,91,182,16,
 							103,188,16,98,178,1,78,153,226,42,112,181,249,59,123,187,
 							248,53,112,170,227,26,80,134,186,236,30,79,127,173,219,8,
 							51,94,136,177,217,0,39,76,113,149,184,218,252,29,61,93,
 							124,154,184,213,241,13,40,67,93,118,143,167,191,214,237,4,
 							25,47,68,88,108,128,147,166,184,202,220,237,254,14,30,46,
 							62,77,92,106,120,134,148,161,174,187,199,211,223,235,246,2,
 							12,23,34,44,54,64,73,83,92,101,110,118,127,135,143,151,
 							159,166,174,181,188,195,202,208,215,221,227,233,239,245,251,1};
 */
 
 
#define	CSDAC RA1		//DAC Select
#define	Quant RB1		//Quant switch
#define Trig_In RB0		//Trigger input
#define Trig1_Out RB2	//Trigger 1 output
#define Trig2_Out RB3	//Trigger 2 output
#define	REC1 RB4		// Rec/Play swith
#define	REC2 RB5
#define	SDI RA7			// 
#define SCK RA0
#define INTEXT RA6		// Int-Ext switch
#define	DACa 0b0011000000000000			// 0x1000
#define	DACb 0b1011000000000000			// 0x9000

signed char
Diff;

unsigned char
Rnd1, Rnd2,
Mode1,
t1,t2,
i,j,n,
temp,
Loop,
Ext,
Timer,
TimerHi,
TimerLo,
PreDiv,
Div,
Mode,
Flag1,			//Recording Track1
Flag2,			//Recording Track2
Rec_Play,
updown, 		// controle le sens de comptage de la piste 1
canon_flag,		// mode canon
Rec_Notes1,		//nombre de notes enregistres de la piste 1
Rec_Notes2,		//nombre de notes enregistres de la piste 2
Play_Notes1,	//nombre de notes joues de la piste 1
Play_Notes2;	//nombre de notes joues de la piste 2

unsigned short 
Tx_Data,
// j'ai force les deux tableaux a se ranger dans la banque 2 sinon j'avais des problemes de compil.
bank2 Track1[48],   // Track 1 
bank2 Track2[44];


float Tmp;

void ShortDelay(void)
{
	for(i=0;i<30;i++)
	for(j=0;j<3;j++);
}

void Init_PIC(void)
{
	OSCCON = 0b01111100;		//osc  8 MHz
	TRISA = 0b01111100;			//port A en output
	PORTA = 0b00000001;			// dselecte le DAC 
	TRISB = 0b11110011;			// Port B = input				
	OPTION = 0b00000011;		//RBPU/INTEDG/T0CS/T0SE/PSA/PS2/PS1/PS0	
}

void Init_ADC(void)
{	
	ANSEL = 0b00011100;			// RA2, RA3, RA4 analog input
	ADCS2 = 1;					// Clock /2 for ADC
	ADCS0 = 1;					// Clock 1/16
	ADCON1 = 0b10000000;		// right justified, Vref = Vdd, Vss	
}	
	
void Init_Interrupt(void)
{
	GIE = 1;		//enables global interrupts
	PEIE = 1;		//enables all periph interrupts
	INT0IE = 1;		//enables RB0 interrupt
	RBIE = 0;		//disables port change interrupt
	RCIE = 0;		//disable rx interrupts
	TXIE=0;			//disable tx interrupts
	INTEDG = 0; 		//interrupt on the falling edge of RB0
	TMR1CS = 0;			//Internal clock for Timer1
	T1CKPS0 = 1;		//prescaler 1:8 for Timer1
	T1CKPS1 = 1;
	TMR1ON = 1;			// Timer1 On
}

short ReadInput(void)
{
	ADCON0 = 0b10100001;
	ShortDelay();
	ADFM = 1;		//right justified
	ADGO = 1;		//start the ADC
	while(ADGO) continue;
	return ((ADRESH<<10)+(ADRESL<<2));
}

unsigned char ReadFrq(void)
{
	ADCON0 = 0b10010001;
	ShortDelay();
	ADFM = 0;		//left justified
	ADGO = 1;
	while(ADGO) continue;
	return (ADRESH);
}

char ReadMode(void)
{
	ADCON0 = 0b10011001;
	ShortDelay();
	ADFM = 0;		//left justified
	ADGO = 1;
	while(ADGO) continue;
	return(ADRESH);
}

void SendSPI(short DAC,short Tx_Data)
{
	if (Quant == 0)
	{
		Tx_Data = Tx_Data + 12;
		Diff = Tx_Data % 67;
		Tx_Data = Tx_Data - Diff + 12;
	}
	Tx_Data =  Tx_Data + DAC;
	CSDAC = 0;			//Chip select
	for ( n=0; n < 16; n++)
	{
		SCK = 0;
		Tx_Data = Tx_Data << 1;
		SDI = CARRY;
		SCK = 1;
	}
	CSDAC = 1;
}

void Trigger1Out(void)
{
	Trig1_Out = 1;
	ShortDelay();
	ShortDelay();
	Trig1_Out = 0;
}

void Trigger2Out(void)
{
	Trig2_Out = 1;
	ShortDelay();
	ShortDelay();
	Trig2_Out = 0;
}		

// j'ai ajout un parametre flag qui permet de distinguer si on est en mode record ou play
// cela permet de supprimer des redondances de code qui alourdissait la memoire
// j'ai modifie completement certains modes
void PlayTrack1(char flag)
{
	switch(Mode)
	{

// mode inchange
		case 0:			// regular mode
			SendSPI(DACa,Track1[Play_Notes1]);
			Play_Notes1++;		
			if(Play_Notes1>Rec_Notes1) Play_Notes1 = 0;
			Trigger1Out();
			PreDiv = 0;
			canon_flag = 0;
			break;
// j'ai modifie le mode 2 qui maintenant joue la piste 1 a l'envers
		case 1:			//play  Track 1 in reverse
			SendSPI(DACa , Track1[Rec_Notes1-Play_Notes1]);
			Play_Notes1++;		
			if (Play_Notes1>Rec_Notes1) Play_Notes1 = 0;
			Trigger1Out();
			PreDiv = 0;
			canon_flag = 0;
			break;

// j'ai modifie le mode 3 qui maintenant joue la piste 1 a l'endroit puis a l'envers
		case 2:			//play Track 1 up and down
			if (updown)
				SendSPI(DACa , Track1[Rec_Notes1-Play_Notes1]);
			else
				SendSPI(DACa , Track1[Play_Notes1]);
			Play_Notes1++;		
			if (Play_Notes1>Rec_Notes1) { Play_Notes1 = 0; updown = 1 - updown; };
			Trigger1Out();
			PreDiv = 0;
			canon_flag = 0;
			break;


// j'ai modifie le mode 4 qui maintenant joue la piste 1 a l'endroit et fait jouer la meme mlodie en canon sur la voix 2
		case 3:			// mode canon
			SendSPI(DACa,Track1[Play_Notes1]);
			Play_Notes1++;		
			if (Play_Notes1>Rec_Notes1) Play_Notes1 = 0;
			Trigger1Out();
			PreDiv = 0;
			canon_flag = 1;
			break;

// il s'agit de l'ancien mode 4 deplace en 5
		case 4:			//RND Track 1
			Rnd1 = (int)rand() % Rec_Notes1;
			if (Rnd1 == Rnd2) Rnd1 = (int)rand() % Rec_Notes1;
			if (Rnd1 == Rnd2) Rnd1 = (int)rand() % Rec_Notes1;
			SendSPI(DACa , Track1[Rnd1]);
			Rnd2 = Rnd1;
			Trigger1Out();
			PreDiv = 0;
			canon_flag = 0;
			break;

// mode inchange
		case 5:			// Track 2 joue 2 fois moins vite
			if (flag) return;
			SendSPI(DACa , Track1[Play_Notes1]);
			Play_Notes1++;		
			if(Play_Notes1>Rec_Notes1) Play_Notes1 = 0;
			Trigger1Out();
			PreDiv = 1;
			canon_flag = 0;
			break;

		case 6:			// Track 2 joue 4 fois moins vite
			if (flag) return;
			SendSPI(DACa , Track1[Play_Notes1]);
			Play_Notes1++;		
			if(Play_Notes1>Rec_Notes1) Play_Notes1 = 0;
			Trigger1Out();
			PreDiv = 2;
			canon_flag = 0;
			break;

		case 7:			// Track 2 joue 8 fois moins vite
			if (flag) return;
			SendSPI(DACa , Track1[Play_Notes1]);
			Play_Notes1++;		
			if(Play_Notes1>Rec_Notes1) Play_Notes1 = 0;
			Trigger1Out();
			PreDiv = 3;
			canon_flag = 0;
			break;																
	}
}

void PlayTrack2(void)
{
unsigned char play_note;

	switch(PreDiv)
	{
		case 0:			// No division
			if (canon_flag == 0) // mode normal
			{
				SendSPI(DACb,Track2[Play_Notes2]);
				Play_Notes2++;
				if (Play_Notes2>Rec_Notes2) Play_Notes2 = 0;
				Trigger2Out();
			}
			else // mode canon
			{
				play_note = Play_Notes1 + 3;  // ici le decalage est de quatre notes mais on peut en choisir un plus petit ou plus grand
				play_note %= (Rec_Notes1+1);
				SendSPI(DACb,Track1[play_note]);
				Trigger2Out();
			}
			break;

		case 1:			//Div by 2
			Div++;
			if(Div & 2)
			{  //Div by 2
				SendSPI(DACb , Track2[Play_Notes2]);
				Play_Notes2++;
				if (Play_Notes2>Rec_Notes2) Play_Notes2 = 0;
				Trigger2Out();
				Div = 0;
			}
			break;
			
		case 2:			//Div by 4
			Div++;
			if (Div & 4)
			{
				SendSPI(DACb , Track2[Play_Notes2]);
				Play_Notes2++;
				if (Play_Notes2>Rec_Notes2) Play_Notes2 = 0;
				Trigger2Out();
				Div = 0;
			}
			break;

		case 3:			//Div by 8
			Div++;
			if(Div & 8)
			{
				SendSPI(DACb , Track2[Play_Notes2]);
				Play_Notes2++;
				if (Play_Notes2>Rec_Notes2) Play_Notes2 = 0;
				Trigger2Out();
				Div = 0;
			}
			break;
	}//sw
}

main()
{
unsigned char tempo;

	Init_PIC();
	Init_Interrupt();
	Init_ADC();
	Flag1 = 0;
	Flag2 = 0;
	Play_Notes1 = 0;
	Play_Notes2 = 0;
	Div = 0;
	updown = 0;
	canon_flag = 0;
	Trig1_Out = 0;
	Trig2_Out = 0;

	for(;;)
	{			//infinite loop
		TMR1IE = 0;
		Mode1 = ReadMode();	
		// lecture du tempo modifie avec adressage direct des tableaux
		tempo = ReadFrq();
		TimerHi = THIGH[tempo];		//load the MSB Timer value
		TimerLo = TLOW[tempo];
		if (INTEXT)
			{INT0IE = 1; TMR1IE = 0; Ext = 0; Loop = 24;} //RB0 interrupt
		else
			{INT0IE = 0; TMR1IE = 1;} //Timer interrupt
	}
}//main


void interrupt Inter(void)
{
	INT0IF = 0;				//clear interrupt flag bit	
	TMR1IF = 0;				//clear interrupt flag bit 
	TMR1L = 0;			//Ensures no rollover into TMR1H
	TMR1L = TimerLo; 			
	TMR1H = TimerHi;

//	(Mode1 < 255) Mode = 7;
	// modification : forcage du mode 7 par defaut
	// car si cela marchait avec un potentiometre, le code
	// ne detecte pas l'etat 255 quand on utilise une chaine de resistance et commutateur rotatif
	Mode = 7;
	if (Mode1 < 238) Mode = 6;
	if (Mode1 < 201) Mode = 5;
	if (Mode1 < 164) Mode = 4;
	if (Mode1 < 128) Mode = 3;
	if (Mode1 < 92) Mode = 2;
	if (Mode1 < 55) Mode = 1;
	if (Mode1 < 17) Mode = 0;

	if (Loop == 24)
	{ 				// Timer 1 is too fast we must divide by 24 (or more)

		Rec_Play = 0;			// Read the position of the switch Rec Play
		if(REC1==0)
		{
			Rec_Play = 1;
		}
		if(REC2==0)	Rec_Play = 2;

		switch(Rec_Play)
		{	
			case 0:		//the 2 tracks are played
				if (Flag1||Flag2) { Play_Notes1 = 0; Play_Notes2 = 0; Flag1 = 0; Flag2 = 0;}
				PlayTrack1(0);
				PlayTrack2();
				break;
		
			case 1:				//Record track 1
				if (Flag1) 
				{
					Rec_Notes1++;
					if (Rec_Notes1 == 48) {Rec_Notes1 = 0; }
					Track1[Rec_Notes1] = ReadInput();
				}
				else
				{
					Track1[0] = ReadInput();
					Rec_Notes1 = 0;
					Play_Notes2 = 0;		// Clear Track 2
					Flag1 = 1;
				}
				SendSPI(DACa , Track1[Rec_Notes1]);
				Trigger1Out();
				break;
		
			case 2:		// Record Track 2
				if (Flag2)
				{
					Rec_Notes2++;
					if (Rec_Notes2 == 44) {Rec_Notes2 = 0;}
					Track2[Rec_Notes2] = ReadInput();
				}
				else
				{
					Track2[0] = ReadInput();
					Rec_Notes2 = 0;
					Play_Notes1 = 0;
					Flag2 = 1;
				}
				SendSPI(DACb , Track2[Rec_Notes2]);
				Trigger2Out();  
				// j'ai supprime les redondances de code en invoquant Playtrack avec le parametre 1
				PlayTrack1(1);
				break;		
		}
		Loop = 0;
	}//if Loop

	Loop++;
}
				